function kor=kern_kor(im1,im2)

tic
im1=double(im1(:,:,1));
im2=double(im2(:,:,1));

%dla obrazu im liczymy lokalnie wspolczynnik korelacji przy uzyciu kernela
%im2
%

%okreslamy rozmiar kernela
[a1,a2]=size(im2);

wer=im2;
wer=wer-mean(wer(:)); %odjecie sredniej

%poszerzenie probki do wymiarow okna przeszukiwan
w1s=zeros(size(im1));
w1s(1:a1,1:a2)=wer;

%w2=kwadrat(im2,a+2*rmax,x,y);
w2=im1;

f1=fft2(w1s);
f2=fft2(w2);

%licznik
kor=real((ifft2(f2.*conj(f1))));

%mianownik
mi1=sum(sum(wer.^2));

mask=zeros(size(im1));
mask(1:a1,1:a2)=1;
mm=conj(fft2(mask));
su2k=real(ifft2(fft2(w2.^2).*mm));
su2=real(ifft2(f2.*mm));

mi2=(su2k - (su2.^2)/(a1*a2));
mi2=mi2.*(mi2>=0);
%sum(sum(mi2<0))
mi=sqrt(mi1*mi2);
mi0=(mi==0); %sprawdzamy gdzie mianownik osiaga zero

%laczenie
kor=(kor./(mi0+mi)).*(~mi0);%uwazamy zeby nie bylo dzielenia przez zero
kor=kor(1:end-a1+1,1:end-a2+1);

% dodajemy zera na brzegach, żeby miec odpowiedni rozmiar
KOR=zeros(size(im1));
KOR((a1-1)/2+1:end-(a1-1)/2,(a2-1)/2+1:end-(a2-1)/2)=kor;
kor=KOR;

toc