function [X,Y]=lokalizacja(im)

% funkcja wyrzuca wspolrzedne czasteczek znalezionych na obrazku im

im=double(im);

im(1:10,:)=0; % wyrzucamy naglowek

%wyrzucamy plamke
im(752:828,540:622)=0;


% filtrujemy obrazy przez zastosowanie operacji splotu z gausowskimi kernelami

%tworzymy kernel
x=[-3:3];
x=x(ones(7,1),:);
r=sqrt(x.^2+x'.^2);

sigma1=.7;
sigma2=2;

g1=exp(-(r.^2)/(2*sigma1^2));

g2=exp(-(r.^2)/(2*sigma2^2));

% liczymy sploty
kor1=kern_kor(im,g1);
kor2=kern_kor(im,g2);

% mask jest obrazem po progowaniu - jedynki odpowiadaja obrazom czasteczek
mask=(((kor2>.5)|(kor1>.5)).*(im>60));

% 
% Y=[];
% X=[];
% 
% 
% while sum(mask(:))>0
% 
% [y,x]=find(mask);
%     
% k=zlep4(y(1),x(1),mask);
% 
% [yy,xx]=find(k);
% Y=[Y,mean(yy)];
% X=[X,mean(xx)];
% 
% mask=mask-k;
% sum(mask(:))
% 
% end

% 
% [Y,X]=find(mask);
% 
% x=X(ones(size(X)),:);
% y=Y(ones(size(Y)),:);
% 
% M=sqrt((x-x').^2+(y-y').^2);
% 
% M=(M>0)&(M<2);
% 
% YY=Y(sum(~M));
% XY=X(sum(~M));


% lokalizujemy poszczegolne czasteczki
[X1,Y1,X2,Y2]=wyc(mask);

X=(X1+X2)/2;
Y=(Y1+Y2)/2;
