function policz_srednice

path='/media/sda4/praca/silver-nanoparticles-50x-2';

% path - sciezka do plikow z pozycjami czasteczek

% program wczytuje pliki z pozycjami czasteczek w seriach po 100 plikow 
% i laczy je w trajektorie.
% kazda seria zaczyna sie od pliku o numerze ty , gdzie ty jest w petli zmieniane co 10.
% dzieki temu otrzymujemy trajektorie tych samych czasteczek liczone dla roznych czasow startowych ty.
% trajektorie sa krotsze, ale za to jest ich wiecej, bo mniej czasteczek "ucieka" dla 100 fotografii 
% niz gdybysmy przeprowadzili te opearacje dla calej serii.


dt=0.02; %interwal pomiedzy dwiema fotografiami
mu=8.9*(10^-4); %lepkosc plynu
k=1.38*10^(-23); %stala Boltzmana
T=(27+273); %temperatura plynu
lh=(300*10^-6)/1234; %skala [m/pixel]




dane=dir([path,'/*.mat']);




for ty=1:10:(length(dane)-100)





    load( [path,'/',dane(ty).name] );
    x=[X];
    y=[Y];

    %size(x)

    length(dane);

    for i=ty+1 : ty+100 %length(dane)
        %i
        X=[];
        Y=[];
        dane(i).name
        load( [path,'/',dane(i).name] );
        %dane(i).name
        X1=x(end,:);
        Y1=y(end,:);

        X2=X;
        Y2=Y;

        maxmov=20; %maksymalne przesuniecie czastek

        %size(X1)
        %size(X2)

        L1=length(X1);
        L2=length(X2);

        XX1=X1(ones(1,L2),:);
        YY1=Y1(ones(1,L2),:);

        XX2=X2(ones(L1,1),:)';
        YY2=Y2(ones(L1,1),:)';

        %size(XX1)
        %size(XX2)

        % obliczamy dlugosc wszystkich potencjalnych przemieszczen
        R=sqrt( (XX1-XX2).^2 + (YY1-YY2).^2 );

        x1=[];
        y1=[];
        x2=[];
        y2=[];
        sx=[];
        sy=[];

        while sum(R(:)<=maxmov)>0
            %   sum(R(:)<=maxmov)
            [n,m]=find(R==min(R(:)));
            %wyjmujemy wlasciwa kolumne z macierzy danych
            % i dodajemy nastepny punkt
            %   size(x(:,m(1)))
            %  size(X2(n(1)))
            sx=[x(:,m(1));X2(n(1))];
            sy=[y(:,m(1));Y2(n(1))];


            %size(sx)

            %tworzymy z wybranych kolumn nowa macierz danych
            x1=[x1,sx];
            y1=[y1,sy];


            %size(x1)

            R(:,m(1))=maxmov+1;
            R(n(1),:)=maxmov+1;



        end

        x=x1;
        y=y1;

        %size(x)

    end
    
    x=x*lh;
    y=y*lh;
    size(x)
    s2=1.5*( mean( ( x(2:end,:)-x(1:end-1,:)).^2) + mean((y(2:end,:)-y(1:end-1,:)).^2));
    size(s2)
    
    D=s2/(2*dt);
    size(D)
    dp=(D.^-1)*(k*T)/(3*pi*mu);
    dp=dp*(10^9); % przeliczamy na nanometry
    
    name=['dia',num2str(ty)];
    eval(['save ',name,' dp -V6']);


end