function varargout = silosy2(varargin)
% SILOSY2 M-file for silosy2.fig
%      SILOSY2, by itself, creates a new SILOSY2 or raises the existing
%      singleton*.
%
%      H = SILOSY2 returns the handle to a new SILOSY2 or the handle to
%      the existing singleton*.
%
%      SILOSY2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SILOSY2.M with the given input arguments.
%
%      SILOSY2('Property','Value',...) creates a new SILOSY2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before silosy2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to silosy2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help silosy2

% Last Modified by GUIDE v2.5 15-Sep-2008 14:08:26

% Begin initialization code - DO NOT EDIT

global initial_dir current_dir  filename
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @silosy2_OpeningFcn, ...
                   'gui_OutputFcn',  @silosy2_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before silosy2 is made visible.
function silosy2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to silosy2 (see VARARGIN)

% Choose default command line output for silosy2
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

global initial_dir current_dir



if nargin == 3,
    initial_dir = pwd;
    current_dir = pwd;
elseif nargin > 4
    if strcmpi(varargin{1},'dir')
        if exist(varargin{2},'dir')
            initial_dir = varargin{2};
        else
            errordlg('Input argument must be a valid directory','Input Argument Error!')
            return
        end
    else
        errordlg('Unrecognized input argument','Input Argument Error!');
        return;
    end
end
% Populate the listbox
load_listbox(initial_dir,handles)

%imagesc(ones(100))
%axis off

%text(50,50,'No image')

% UIWAIT makes silosy2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = silosy2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton_Prev.
function pushbutton_Prev_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Prev (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global current_dir filename
lista_plikow=dir(current_dir);
dlug=length(lista_plikow);

step=str2double(get(handles.edit_step,'String'));

%znalezienie filename na liscie
for i=1: dlug
   
    FILENAME=lista_plikow(i).name;
    
    if length(FILENAME)==length(filename)
        if mean(FILENAME==filename)==1
            break
        end
    end
    
    
end


%zmiana filename
if i-step>0
    filename=lista_plikow(i-step).name;
    set(handles.text1,'String',filename);
    set(handles.listbox1,'Value',i-step)
end

% --- Executes on button press in pushbutton_Next.
function pushbutton_Next_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Next (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global current_dir filename
lista_plikow=dir(current_dir);
dlug=length(lista_plikow);

step=str2double(get(handles.edit_step,'String'));

%znalezienie filename na liscie
for i=1: dlug
   
    FILENAME=lista_plikow(i).name;
    
    if length(FILENAME)==length(filename)
        if mean(FILENAME==filename)==1
            break
        end
    end
    
    
end


%zmiana filename
if i+step<=dlug
    filename=lista_plikow(i+step).name;
    set(handles.text1,'String',filename)
    set(handles.listbox1,'Value',i+step);
end




function edit_step_Callback(hObject, eventdata, handles)
% hObject    handle to edit_step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_step as text
%        str2double(get(hObject,'String')) returns contents of edit_step as a double


% --- Executes during object creation, after setting all properties.
function edit_step_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_step (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1
global initial_dir current_dir filename
%PROMIEN=50;
get(handles.figure1,'SelectionType');
if strcmp(get(handles.figure1,'SelectionType'),'open')
    index_selected = get(handles.listbox1,'Value');
    file_list = get(handles.listbox1,'String');
    filename = file_list{index_selected};
    if  handles.is_dir(handles.sorted_index(index_selected))
        %cd (filename)
        
        cd([current_dir,'/',filename])
        current_dir=pwd;
        cd(initial_dir)
        load_listbox(current_dir,handles);
    else
        [path,name,ext,ver] = fileparts(filename);
        set(handles.text1,'String',filename)
        switch ext
            case '.bmp'
                %guide (filename)
                wczytaj(handles);
            case '.png'
                wczytaj(handles);
            case '.jpg'
                wczytaj(handles);
            case '.tif'
                wczytaj(handles);
            case '.gif'
                wczytaj(handles);
            otherwise
                try
                    
                    %open(filename)
                catch
                    errordlg(lasterr,'File Type Error','modal')
                end
       end
    end
end


% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function load_listbox(dir_path,handles)
%cd (dir_path)
global current_dir
dir_struct = dir(dir_path);
[sorted_names,sorted_index] = sortrows({dir_struct.name}');
handles.file_names = sorted_names;
handles.is_dir = [dir_struct.isdir];
handles.sorted_index = sorted_index;
guidata(handles.figure1,handles)
set(handles.listbox1,'String',handles.file_names,'Value',1)
set(handles.text1,'String',current_dir)






function edit_level_Callback(hObject, eventdata, handles)
% hObject    handle to edit_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_level as text
%        str2double(get(hObject,'String')) returns contents of edit_level as a double


% --- Executes during object creation, after setting all properties.
function edit_level_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_Ev_min_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Ev_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Ev_min as text
%        str2double(get(hObject,'String')) returns contents of edit_Ev_min as a double


% --- Executes during object creation, after setting all properties.
function edit_Ev_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Ev_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_Ev_max_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Ev_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Ev_max as text
%        str2double(get(hObject,'String')) returns contents of edit_Ev_max as a double


% --- Executes during object creation, after setting all properties.
function edit_Ev_max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Ev_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_Auto_Ev.
function pushbutton_Auto_Ev_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Auto_Ev (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global filename current_dir ev
readILA([current_dir,'/',filename]);
set(handles.edit_Ev_min,'String',num2str(min(ev(:))));
set(handles.edit_Ev_max,'String',num2str(max(ev(:))));



function edit_Ep_min_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Ep_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Ep_min as text
%        str2double(get(hObject,'String')) returns contents of edit_Ep_min as a double


% --- Executes during object creation, after setting all properties.
function edit_Ep_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Ep_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_Ep_max_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Ep_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Ep_max as text
%        str2double(get(hObject,'String')) returns contents of edit_Ep_max as a double


% --- Executes during object creation, after setting all properties.
function edit_Ep_max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Ep_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_Auto_Ep.
function pushbutton_Auto_Ep_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Auto_Ep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global filename current_dir ep
readILA([current_dir,'/',filename]);
set(handles.edit_Ep_min,'String',num2str(min(ep(:))));
set(handles.edit_Ep_max,'String',num2str(max(ep(:))));



function edit_V1_min_Callback(hObject, eventdata, handles)
% hObject    handle to edit_V1_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_V1_min as text
%        str2double(get(hObject,'String')) returns contents of edit_V1_min as a double


% --- Executes during object creation, after setting all properties.
function edit_V1_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_V1_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_V1_max_Callback(hObject, eventdata, handles)
% hObject    handle to edit_V1_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_V1_max as text
%        str2double(get(hObject,'String')) returns contents of edit_V1_max as a double


% --- Executes during object creation, after setting all properties.
function edit_V1_max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_V1_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_Auto_V1.
function pushbutton_Auto_V1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Auto_V1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function edit_V2_min_Callback(hObject, eventdata, handles)
% hObject    handle to edit_V2_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_V2_min as text
%        str2double(get(hObject,'String')) returns contents of edit_V2_min as a double


% --- Executes during object creation, after setting all properties.
function edit_V2_min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_V2_min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_V2_max_Callback(hObject, eventdata, handles)
% hObject    handle to edit_V2_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_V2_max as text
%        str2double(get(hObject,'String')) returns contents of edit_V2_max as a double


% --- Executes during object creation, after setting all properties.
function edit_V2_max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_V2_max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_Auto_V2.
function pushbutton_Auto_V2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Auto_V2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global filename current_dir U V
readILA([current_dir,'/',filename]);
u=sqrt(U.^2+V.^2);
set(handles.edit_V2_min,'String',num2str(min(u(:))));
set(handles.edit_V2_max,'String',num2str(max(u(:))));

% --- Executes on button press in pushbutton_OK.
function pushbutton_OK_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_OK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

wyswietl(handles)



function wyswietl(handles)

global filename current_dir x_min x_max y_min y_max ep ev X Y U V xs ys


%[x,y,vx,vy]=
readILA([current_dir,'/',filename]);


[n,m]=size(U);







figure
text(0,0,filename)

subplot(1,2,1);

%pcolor(X,Y,ev)
%shading interp
c1=str2double(get(handles.edit_Ev_min,'String'));
c2=str2double(get(handles.edit_Ev_max,'String'));
imagesc(X(1,:),Y(:,1)',ev,[c1 c2]);
%quiver(x,y,vx,vy)
hold on
h=line(xs,ys);
set(h,'Color',[1 1 1],'LineWidth',2)
axis xy
axis equal
axis([x_min,x_max,y_min,y_max ])
colorbar
title('Ev')


subplot(1,2,2)

pcolor(X,Y,ep)
shading interp
c1=str2double(get(handles.edit_Ep_min,'String'));
c2=str2double(get(handles.edit_Ep_max,'String'));
imagesc(X(1,:),Y(:,1)',ep,[c1 c2]);
h=line(xs,ys);
set(h,'Color',[1 1 1],'LineWidth',2)
axis xy
axis equal
axis([x_min,x_max,y_min,y_max ])
colorbar
title('Ep');


figure

subplot(1,2,1)
title('pole predkosci')
h=line(xs,ys);
set(h,'Color',[0 0 0],'LineWidth',2)
hold on
step=round(m/10);
quiver(X(1:step:end,1:step:end),Y(1:step:end,1:step:end),U(1:step:end,1:step:end),V(1:step:end,1:step:end),6)
%pcolor(X,Y,e22)


%imagesc(V)
axis equal

axis([x_min,x_max,y_min,y_max ])

subplot(1,2,2)

%pcolor(X,Y,sqrt(U.^2+V.^2))
c1=str2double(get(handles.edit_V2_min,'String'));
c2=str2double(get(handles.edit_V2_max,'String'));
imagesc(X(1,:),Y(:,1)',sqrt(U.^2+V.^2),[c1 c2]);
%shading interp
hold on
h=line(xs,ys);
set(h,'Color',[1 1 1],'LineWidth',2)
axis xy
axis equal
%axis([x_min,x_max,y_min,y_max ])
colorbar
title('modul predkosci');
%quiver(x,y,vx,vy,10)

















%function [x,y,vx,vy]
function []=readILA(nomfichier)

global current_dir x_min x_max y_min y_max ep ev X Y U V xs ys

fid=fopen(nomfichier);
text=fgets(fid);
%text(8)=[''''];text(end)=[];text(end)=[''''];;
text=fgets(fid);text=fgets(fid);
ii=findstr(text,'I=');jj=findstr(text,'J=');
if ~isempty(ii); I=str2num(text(ii+2:ii+6));end
if ~isempty(jj); J=str2num(text(jj+2:ii+6));end
text=fgets(fid);
[M,count]=fscanf(fid,'%g',[4,inf]);M=M';
x=M(:,1);y=M(:,2);
vx=M(:,3);vy=M(:,4);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%przeskalowanie i odcinanie
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load([current_dir,'/case_data']);
x_min=min(xs);
y_min=min(ys);
x_max=max(xs);
y_max=max(ys);

%obciecie pola
maska=((x>=x_min) & (x<=x_max) & (y>=y_min) &(y<=y_max));


%wyciecie punktow na skosach:
a=(ys(3)-ys(2))/(xs(3)-xs(2));
mask1=(y>=(a*(x-xs(2))+ys(2)));
a=(ys(5)-ys(4))/(xs(5)-xs(4));
mask2=(y<=(a*(x-xs(4))+ys(4)));

mask= maska & mask2 & mask1;
x=x(mask);
y=y(mask);
vx=vx(mask);
vy=vy(mask);


%obrot wspolrzednych
x_o=y_max-y+1;
y_o=x;
Vx=-vy;
Vy=vx;

x_s=y_max-ys+1;
y_s=xs;


x=x_o; clear x_o;
y=y_o; clear y_o;
vx=Vx; clear Vx;
vy=Vy; clear Vy;

xs=x_s; clear x_s;
ys=y_s; clear y_s;






x_min=min(x(:));
y_min=min(y(:));
x_max=max(x(:));
y_max=max(y(:)); 

%interpolacja na regularna siatke
%ustalenie kroku siatki
krok=min(x(x>x_min))-x_min;


for i=1:length(x)
    U(1+(y(i)-y_min)/krok,1+(x(i)-x_min)/krok)=vx(i);
    V(1+(y(i)-y_min)/krok,1+(x(i)-x_min)/krok)=vy(i);
   % X(1+(y(i)-y_min)/krok,1+(x(i)-x_min)/krok)=x(i);
   % Y(1+(y(i)-y_min)/krok,1+(x(i)-x_min)/krok)=y(i);
end

[n,m]=size(U);
X=repmat([1:m]*krok,n,1);
Y=repmat([1:n]'*krok,1,m);



%Przeskalowujemy
U=skala*U/deltaT;
V=skala*V/deltaT;
X=X*skala;
Y=Y*skala;
xs=xs*skala;
ys=ys*skala;
%wycentrowanie
xc=mean(xs(:));
yc=ys(2);

X=X-xc;
xs=xs-xc;
Y=-Y+yc;
ys=-ys+yc;
V=-V;

x_min=min(X(:));
y_min=min(Y(:));
x_max=max(X(:));
y_max=max(Y(:)); 



%liczymy odksztalcenia
e11=zeros(size(U));
e11(:,2:end-1)=(U(:,3:end)-U(:,1:end-2)) / (X(1,3)-X(1,1));

e22=zeros(size(U));
e22(2:end-1,:)=(V(3:end,:)-V(1:end-2,:)) / (Y(3,1)-Y(1,1));

ev=e11+e22;

e12a=zeros(size(U));
e12b=zeros(size(U));
e12a(:,2:end-1)=(V(:,3:end)-V(:,1:end-2)) / (X(1,3)-X(1,1));
e12b(2:end-1,:)=(U(3:end,:)-U(1:end-2,:)) / (Y(3,1)-Y(1,1));
e12=.5*(e12a+e12b);

ep=sqrt( (e11-(1/3)*ev).^2 + (e22-(1/3)*ev).^2  + 2*e12.^2 );
